if (typeof browser === "undefined") {
    var browser = chrome;
}
const err = (err) => console.error("error: " + err);
const urlovi = ["https://www.geoguessr.com/seterra/*/vg*/*", "https://www.geoguessr.com/seterra/*/fl*/*", "https://geoguessr.com/seterra/*/vg*/*", "https://geoguessr.com/seterra/*/fl*/*", "https://www.geoguessr.com/vg*/*", "https://www.geoguessr.com/fl*/*","https://geoguessr.com/vg*/*", "https://geoguessr.com/fl*/*"];
const regeks1 = /https:\/\/(www\.)?geoguessr\.com\/seterra\/.*\/vg.*\/.*/;
const regeks2 = /https:\/\/(www\.)?geoguessr\.com\/seterra\/.*\/fl.*\/.*/;
const regeks3 = /https:\/\/(www\.)?geoguessr\.com\/vg.*\/.*/;
const regeks4 = /https:\/\/(www\.)?geoguessr\.com\/fl.*\/.*/;
const enableButtons = async () => {
    browser.tabs.query({ active: true }).then(res => {
        const dugmad = document.getElementsByClassName("disable");
        if (res && Boolean(res[0].url) && (res[0].url.match(regeks1) || res[0].url.match(regeks1) || res[0].url.match(regeks3) || res[0].url.match(regeks4))) {
            for (const dugme of dugmad) {
                dugme.disabled = false;
            }
        } else {
            for (const dugme of dugmad) {
                dugme.disabled = true;
            }
        }
    }, err);
};
enableButtons();
browser.tabs.onActivated.addListener(enableButtons);

const checkboxovi = document.getElementById("mainform").getElementsByTagName("input");
for (let i = 0; i < checkboxovi.length; i++) {
    browser.storage.local.get(checkboxovi[i].id).then(item => {
        checkboxovi[i].checked = item[checkboxovi[i].id] || false;
    }, err);
}
for (let i = 0; i < checkboxovi.length; i++) {
    checkboxovi[i].onchange = () => {
        const key = checkboxovi[i].id;
        const value = checkboxovi[i].checked;
        browser.storage.local.set({ [key]: value }).catch(err);
    };
}

document.getElementById("reloadall").onclick = async () => {
    browser.tabs.query({ url: urlovi })
        .then(async tabs => {
            const proms = [];
            for (const tab of tabs) {
                proms.push(browser.tabs.reload(tab.id).catch(err));
            }
            Promise.allSettled(proms).then(() => window.close(), err);
        }, err);
};

document.getElementById("reloadthis").onclick = async (e) => {
    browser.tabs.reload().then(() => window.close(), err);
};

document.getElementById("narrow").onclick = () => {
    browser.storage.local.get("size").then(item => {
        let size = item["size"] || 0;
        size--;
        size = size < 0 ? 0 : size;
        browser.storage.local.set({ "size": size }).catch(err);
        browser.tabs.query({ url: urlovi })
            .then(async tabs => {
                for (const tab of tabs) {
                    browser.tabs.sendMessage(tab.id, "narrow")//.catch(err);;
                }
            }, err);
    }, err);
};

document.getElementById("wide").onclick = () => {
    browser.storage.local.get("size").then(item => {
        let size = item["size"] || 0;
        size = size < 0 ? 0 : size;
        browser.storage.local.set({ "size": ++size }).catch(err);

        browser.tabs.query({ url: urlovi })
            .then(async tabs => {
                for (const tab of tabs) {
                    browser.tabs.sendMessage(tab.id, "wide")//.catch(err);;
                }
            }, err);
    }, err);
};
document.getElementById("reset").onclick = () => {
    browser.storage.local.get("size").then(item => {
        browser.tabs.query({ url: urlovi })
            .then(async tabs => {
                for (const tab of tabs) {
                    browser.tabs.sendMessage(tab.id, "reset")//.catch(err);;
                }
            }, err);
        browser.storage.local.set({ "size": 0 }).catch(err);
    }, err);
};
