if (typeof browser === "undefined") {
    var browser = chrome;
}
let scale = 1;
let scalenum = 0;
const scaleSVG = () => {
    let origHeight = getComputedStyle(document.querySelector("#svgpoint")).height;
    origHeight = origHeight.slice(0, origHeight.length - 2);
    let origWidth = getComputedStyle(document.querySelector("#svgpoint")).width;
    origWidth = origWidth.slice(0, origWidth.length - 2);
    let aspectRatio = origWidth / origHeight;
    let newWidth = getComputedStyle(document.querySelector(".gamewindow")).width;
    newWidth = newWidth.slice(0, newWidth.length - 2);
    const newHeight = newWidth / aspectRatio;

    document.querySelector("#svgpoint").style.width = newWidth + "px";
    document.querySelector("#svgpoint").style.height = newHeight + "px";
    document.querySelector("#svgDiv").style.width = newWidth + "px";
    document.querySelector("#svgDiv").style.height = newHeight + "px";
    scale = newWidth / origWidth;
    scalenum++;
}
const err = (err) => console.error("error: " + err);
const velicina = event => {
    if (event.altKey) {
        if (event.key == "w" || event.keyCode == 87) {
            browser.runtime.sendMessage("wide")//.catch(err);;
            event.stopPropagation();
        }
        else if (event.key == "q" || event.keyCode == 81) {
            browser.runtime.sendMessage("narrow")//.catch(err);;
            event.stopPropagation();
        }
    }
};
document.addEventListener("keyup", velicina, true);
window.addEventListener("load", async () => {
    browser.storage.local.get().then(item => {
        let size = item["size"] || 0;
        size = size < 0 ? 0 : size;
        document.getElementById("contentwrapper").style.maxWidth = 1250 + 100 * size + "px";
        document.getElementById("leftcol").style.maxWidth = 1250 + 100 * size + "px";
		scaleSVG();

		let darkmode = item["darkmode"] || false;
		document.getElementById("chkDarkMode").checked = !darkmode;
		document.getElementById("chkDarkMode").click();
    }, err);
});
browser.runtime.onMessage.addListener(poruka => {
    let stil = getComputedStyle(document.getElementById("contentwrapper")).maxWidth;
    stil = stil.slice(0, stil.length - 2);
    if (poruka == "wide") {
        document.getElementById("contentwrapper").style.maxWidth = parseInt(stil) + 100 + "px";
        document.getElementById("leftcol").style.maxWidth = parseInt(stil) + 100 + "px";
        scaleSVG();
    } else if (poruka == "narrow") {
        let sirina = parseInt(stil) - 100 > 1250 ? parseInt(stil) - 100 : 1250;
        document.getElementById("contentwrapper").style.maxWidth = sirina + "px";
        document.getElementById("leftcol").style.maxWidth = sirina + "px";
        scaleSVG();
    } else {
        document.getElementById("contentwrapper").style.maxWidth = "1250px";
        document.getElementById("leftcol").style.maxWidth = "1250px";
        scaleSVG();
    }
});
