if (typeof browser === "undefined") {
    var browser = chrome;
}
const err = (err) => console.error("error: " + err);
const urlovi = ["https://www.geoguessr.com/seterra/*/vg*/*", "https://www.geoguessr.com/seterra/*/fl*/*", "https://geoguessr.com/seterra/*/vg*/*", "https://geoguessr.com/seterra/*/fl*/*", "https://www.geoguessr.com/vg*/*", "https://www.geoguessr.com/fl*/*","https://geoguessr.com/vg*/*", "https://geoguessr.com/fl*/*"];
const regeks1 = /https:\/\/(www\.)?geoguessr\.com\/seterra\/.*\/vg.*\/.*/;
const regeks2 = /https:\/\/(www\.)?geoguessr\.com\/seterra\/.*\/fl.*\/.*/;
const regeks3 = /https:\/\/(www\.)?geoguessr\.com\/vg.*\/.*/;
const regeks4 = /https:\/\/(www\.)?geoguessr\.com\/fl.*\/.*/;
const redirect = async (tabId, changeInfo, tab) => {
    //if (changeInfo.status != "loading") return; //CHROME ONLY
    if (!changeInfo.url) return;//FIREFOX ONLY
	browser.storage.local.get().then(item => {
		let url = tab.url;
		const old = item["old"] || false;
		if (old && tab.url.match(regeks3)) {
			const split = tab.url.split(/vg.*\//);
			url = "https://geoguessr.com/seterra/en/vg/" + split[1];
		}
		else if (old && tab.url.match(regeks4)) {
			const split = tab.url.split(/fl.*\//);
			url = "https://geoguessr.com/seterra/en/fl/" + split[1];
		}
        else if (!tab.url.match(regeks1) && !tab.url.match(regeks2)) return;
        const split = url.split("?");
        url = split[0] + "?";
        let cquiz = "";
        if (split[1]) {
            const params = split[1].split("&");
            params.forEach(element => {
                if (element.includes("c=")) {
                    cquiz = element;
                }
            });
        }
        for (const p in item) {
            if (item[p] == true && p != "size" && p != "darkmode" && p != "old") {
                url = url + p + "=1&";
            }
        }
        url = url + cquiz;
        if (url.at(-1) == "&") url = url.slice(0, -1);
        if (tab.url != url) {
            browser.tabs.update(tabId, {
                url: url,
                loadReplace: true//FIREFOX ONLY
            }).catch(err);
        }
    }, err);
};

browser.tabs.onUpdated.addListener(redirect);

browser.runtime.onMessage.addListener((poruka, salje) => {
    if (poruka == "wide") {
        browser.storage.local.get("size").then(item => {
            let size = item["size"] || 0;
            size = size < 0 ? 0 : size;
            browser.storage.local.set({ "size": ++size }).catch(err);

            browser.tabs.query({ url: urlovi })
                .then(async tabs => {
                    for (const tab of tabs) {
                        browser.tabs.sendMessage(tab.id, "wide")//.catch(err);
                    }
                }, err);
        }, err);
    } else {
        browser.storage.local.get("size").then(item => {
            let size = item["size"] || 0;
            size--;
            size = size < 0 ? 0 : size;
            browser.storage.local.set({ "size": size }).catch(err);
            browser.tabs.query({ url: urlovi })
                .then(async tabs => {
                    for (const tab of tabs) {
                        browser.tabs.sendMessage(tab.id, "narrow")//.catch(err);
                    }
                }, err);
        }, err);
    }
});
